/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.util;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public class FermentationRecipes {
    private static final Map<Item, Item> INPUT_TO_OUTPUT = Maps.newHashMap();
    private static final Map<Item, Item> INPUT_TO_REMAINDER = Maps.newHashMap();
    private static final Map<Item, Item> OUTPUT_TO_COLLECTOR = Maps.newHashMap();
    private static final Map<Item, Integer> OUTPUT_TO_COUNT = Maps.newHashMap();

    public static void addRecipe(Item input, @Nullable Item remainder, Item output, @Nullable Item collector, @Nullable Integer resultCount) {
        INPUT_TO_OUTPUT.put(input, output);
        if (remainder != null) {
            INPUT_TO_REMAINDER.put(input, remainder);
        }
        if (collector != null) {
            OUTPUT_TO_COLLECTOR.put(output, collector);
        }
        if (resultCount != null) {
            OUTPUT_TO_COUNT.put(output, resultCount);
        }
    }

    public static Item getOutputFromInput(Item input) {
        return INPUT_TO_OUTPUT.get(input);
    }

    public static Item getRemainderFromInput(Item input) {
        return INPUT_TO_REMAINDER.get(input);
    }

    public static boolean isItemInput(Player player, InteractionHand hand) {
        return INPUT_TO_OUTPUT.containsKey(player.m_21120_(hand).m_41720_());
    }

    public static Item getCollector(Item output) {
        return OUTPUT_TO_COLLECTOR.getOrDefault(output, null);
    }

    public static Integer getOutputCount(Item output) {
        return OUTPUT_TO_COUNT.getOrDefault(output, 1);
    }
}

